/**********************************************************************************************

  Copyright (C) 2010 Hilscher Gesellschaft für Systemautomation mbH.
  This program can be used by everyone according the "industrialNETworX Public License INPL".
  The license can be downloaded under <http://www.industrialNETworX.com>.

***********************************************************************************************

   Last Modification:
    @version $Id: PNIO_api_common.h 21222 2012-01-04 15:29:55Z Benjamin $

   Description:
     common Profinet packet definitions (may be supported by PNM and/or PNS)

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2012-01-03  BM            Created
**************************************************************************************/
#ifndef __PNIO_API_COMMON_H
#define __PNIO_API_COMMON_H

typedef enum {
  /* PNIO_COMMON_PACKET_START  = 0x8600 */
  PNIO_COMMON_CMD_GET_NEIGHBOR_COUNT_REQ                    = 0x8600,
  PNIO_COMMON_CMD_GET_NEIGHBOR_COUNT_CNF                    = 0x8601,
  PNIO_COMMON_CMD_GET_NEIGHBOR_INFO_REQ                     = 0x8602,
  PNIO_COMMON_CMD_GET_NEIGHBOR_INFO_CNF                     = 0x8603,
  PNIO_COMMON_CMD_GET_SWITCH_STATISTICS_REQ                 = 0x8604,
  PNIO_COMMON_CMD_GET_SWITCH_STATISTICS_CNF                 = 0x8605

} PNIO_COMMON_PACKET_COMMANDS_E;


/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__PNIO_COMMON_PACKET)
#endif


/*
* GET NEIGHBOR COUNT SERVICE
*/

/* Get Amount of Neighbors connected to a local port */
/* details can be retrieved using Get Neighbor Info Service */

/* request packet */
typedef __PACKED_PRE struct
{
  /** the port whose count is requested */
  TLR_UINT32 ulPortNum;
} __PACKED_POST PNIO_COMMON_GET_NEIGHBOR_COUNT_REQ_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                        tHead;
  PNIO_COMMON_GET_NEIGHBOR_COUNT_REQ_DATA_T  tData;
} PNIO_COMMON_GET_NEIGHBOR_COUNT_REQ_T;

/* confirmation packet */
typedef __PACKED_PRE struct
{
  /** the port whose count is requested */
  TLR_UINT32 ulPortNum;
  /** the amount of neighbors connected */
  TLR_UINT32 ulNeighborCnt;
} __PACKED_POST PNIO_COMMON_GET_NEIGHBOR_COUNT_CNF_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                        tHead;
  PNIO_COMMON_GET_NEIGHBOR_COUNT_CNF_DATA_T  tData;
} PNIO_COMMON_GET_NEIGHBOR_COUNT_CNF_T;

/* packet union */
typedef union
{
  PNIO_COMMON_GET_NEIGHBOR_COUNT_REQ_T  tReq;
  PNIO_COMMON_GET_NEIGHBOR_COUNT_CNF_T  tCnf;
} PNIO_COMMON_GET_NEIGHBOR_COUNT_PCK_T;


/*
* GET NEIGHBOR INFO SERVICE
*/

/* Get info about a specific Neighbors connected to a local port */

/* request packet */
typedef __PACKED_PRE struct
{
  /** the port to retrieve information */
  TLR_UINT32 ulPortNum;
  /** the neighbor index (starting with 0 for the first neighbor) */
  TLR_UINT32 ulIndex;
} __PACKED_POST PNIO_COMMON_GET_NEIGHBOR_INFO_REQ_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                       tHead;
  PNIO_COMMON_GET_NEIGHBOR_INFO_REQ_DATA_T  tData;
} PNIO_COMMON_GET_NEIGHBOR_INFO_REQ_T;

/* confirmation packet */
#define PNIO_COMMON_NEIGHBOR_FLAG_PORTID_VALID       (0x01)
#define PNIO_COMMON_NEIGHBOR_FLAG_CHASSISID_VALID    (0x02)
#define PNIO_COMMON_NEIGHBOR_FLAG_INTF_MAC_VALID     (0x04)
#define PNIO_COMMON_NEIGHBOR_FLAG_MANAG_ADDR_VALID   (0x08)

#define PNIO_COMMON_NEIGHBOR_STRUCT_VERSION_1        (1)

#define PNIO_COMMON_CHASSISID_SUBTYPE_MAC_ADDRESS    (4)
#define PNIO_COMMON_CHASSISID_SUBTYPE_LOCAL          (7) /* typically NameOfStation for Profinet devices */

#define PNIO_COMMON_PORTID_SUBTYPE_LOCAL             (7)

typedef __PACKED_PRE struct
{
  /** the port the neighbor information belongs to */
  TLR_UINT32 ulPortNum;
  /** the neighbor index */
  TLR_UINT32 ulIndex;
  /** structure version describing the content below */
  TLR_UINT32 ulStructVersion;

  /* flag field to indicate which fields in this packet contain valid data (see above) */
  TLR_UINT32 ulValidFlags;
  /* remote PortId subtype (please refer to IEEE 802.1AB) */
  TLR_UINT8  bPortIdSubtype;
  /* remote ChassisId subtype (please refer to IEEE 802.1AB) */
  TLR_UINT8  bChassisIdSubtype;
  /* remote management address subtype (please refer to ianaAddressFamilyNumbers) */
  TLR_UINT8  bManagAddrSubtype;
  /* remote PortId length */
  TLR_UINT8  bLenPortId;
  /* remote ChassisId length */
  TLR_UINT8  bLenChassisId;
  /* remote management address length */
  TLR_UINT8  bLenManagAddr;
  /* remote interface MAC address */
  TLR_UINT8  abIntfMac[6];
  /* remote ChassisId */
  TLR_UINT8  abChassisId[255];
  /* remote PortId */
  TLR_UINT8  abPortId[255];
  /* remote management address */
  TLR_UINT8  abManagAddr[31];
} __PACKED_POST PNIO_COMMON_GET_NEIGHBOR_INFO_CNF_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                       tHead;
  PNIO_COMMON_GET_NEIGHBOR_INFO_CNF_DATA_T  tData;
} PNIO_COMMON_GET_NEIGHBOR_INFO_CNF_T;

/* packet union */
typedef union
{
  PNIO_COMMON_GET_NEIGHBOR_INFO_REQ_T  tReq;
  PNIO_COMMON_GET_NEIGHBOR_INFO_CNF_T  tCnf;
} PNIO_COMMON_GET_NEIGHBOR_INFO_PCK_T;


/*
 * GET SWITCH STATISTICS SERVICE
 */

/* request packet */
typedef __PACKED_PRE struct
{
  TLR_UINT32 ulPortNum;
} __PACKED_POST PNIO_COMMON_GET_SWITCH_STATISTICS_REQ_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                              tHead;
  PNIO_COMMON_GET_SWITCH_STATISTICS_REQ_DATA_T     tData;
} PNIO_COMMON_GET_SWITCH_STATISTICS_REQ_T;

#define PNIO_COMMON_SWITCH_STAT_STRUCT_VERSION_1             (1)

#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_TRANSMIT_OKAY     (0x0001)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_RECEIVE_OKAY      (0x0002)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_TRANSMIT_ERRORS   (0x0004)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_RECEIVE_ERRORS    (0x0008)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_TRANSMIT_BYTES    (0x0010)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_RECEIVE_BYTES     (0x0020)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_RECEIVE_DROP      (0x0040)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_LINK_DOWN_TRANSM  (0x0080)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_LINK_UP           (0x0100)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_LINK_SPEED        (0x0200)
#define PNIO_COMMON_SWITCH_STAT_VALID_FLAG_LINK_FULLDULPEX   (0x0400)


/* confirmation packet */
typedef __PACKED_PRE struct
{
  /* the port number */
  TLR_UINT32  ulPortNum;
  /* flag field which field of this packet contains valid data */
  TLR_UINT32  ulValidFlags;
  /* the structure version of this packet */
  TLR_UINT32  ulStructVersion;
  /* amount of frames successfully sent */
  TLR_UINT32  ulTransmitOkay;
  /* amount of frames successfully received */
  TLR_UINT32  ulReceiveOkay;
  /* amount of errors during frame sending */
  TLR_UINT32  ulTransmitErrors;
  /* amount of errors during frame receiving */
  TLR_UINT32  ulReceiveErrors;
  /* amount of bytes sent */
  TLR_UINT32  ulTransmitBytes;
  /* amount of bytes received */
  TLR_UINT32  ulReceiveBytes;
  /* amount of frames dropped due to low switch resources */
  TLR_UINT32  ulReceiveDropLowResources;
  /* amount of times link was down while sending (increases with every multicast sent if link is down) */
  TLR_UINT32  ulLinkDownDuringTransmission;
  /* is link up on this port? (0 == down), otherwise up */
  TLR_UINT32  ulLinkUp;
  /* link speed (10MBit/s or 100MBit/s, only valid if LinkUp) */
  TLR_UINT32  ulSpeed;
  /* is link FullDuplex? (0 == HalfDuplex, otherwise FullDuplex) */
  TLR_UINT32  ulFullDuplex;
} __PACKED_POST PNIO_COMMON_GET_SWITCH_STATISTICS_CNF_DATA_T;

typedef struct
{
  TLR_PACKET_HEADER_T                              tHead;
  PNIO_COMMON_GET_SWITCH_STATISTICS_CNF_DATA_T     tData;
} PNIO_COMMON_GET_SWITCH_STATISTICS_CNF_T;

/* packet union */
typedef union
{
  PNIO_COMMON_GET_SWITCH_STATISTICS_REQ_T  tReq;
  PNIO_COMMON_GET_SWITCH_STATISTICS_CNF_T  tCnf;
} PNIO_COMMON_GET_SWITCH_STATISTICS_PCK_T;


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__PNIO_COMMON_PACKET)
#endif

/*************************************************************************************/
#endif /* #ifndef __PNIO_API_COMMON_H */
